<?php
// Inicia a sessão
session_start();
require '../conexao.php';

if (!isset($_SESSION['local'])) {
    echo "<div style='color: white; text-align: center;'>Local não definido.</div>";
    exit;
}

$localAtual = $_SESSION['local'];

// CSS inline otimizado
echo "<style>
    .scroll-container {
        max-height: 400px; /* Ajuste esta altura conforme necessário */
        overflow-y: auto;
        margin: 10px auto;
        border: 2px solid #0066cc;
        border-radius: 5px;
        background-color: #000;
    }
    
    .personagens-table {
        width: 100%;
        border-collapse: collapse;
        color: white;
        font-size: 14px;
    }
    
    .personagens-table th {
        position: sticky;
        top: 0;
        background-color: #001a33;
        color: white;
        padding: 10px;
        border: 1px solid #0066cc;
        text-align: center;
        z-index: 10;
    }
    
    .personagens-table td {
        padding: 8px;
        border: 1px solid #0066cc;
        text-align: center;
        max-width: 150px;
        word-break: break-word;
    }
    
    .personagens-table tr:nth-child(even) {
        background-color: #0a0a0a;
    }
    
    .personagens-table tr:hover {
        background-color: #002b4d;
    }
    
    /* Scrollbar personalizada */
    .scroll-container::-webkit-scrollbar {
        width: 12px;
    }
    
    .scroll-container::-webkit-scrollbar-track {
        background: #001a33;
        border-radius: 6px;
    }
    
    .scroll-container::-webkit-scrollbar-thumb {
        background: #0066cc;
        border-radius: 6px;
        border: 2px solid #001a33;
    }
    
    .scroll-container::-webkit-scrollbar-thumb:hover {
        background: #0099ff;
    }
    
    .title {
        color: white;
        text-align: center;
        margin: 15px 0;
        font-size: 1.4em;
    }
    
    .status-completed {
        color: #00ff00;
        font-weight: bold;
    }
    
    .status-inprogress {
        color: #ff6666;
        font-weight: bold;
    }
    
    .total-personagens {
        color: white;
        text-align: center;
        margin: 10px 0;
        font-size: 0.9em;
    }
</style>";

try {
    $sql = "SELECT personagem, jogador, situacao, cla, cargo, paralisado, reputacao 
            FROM personagens 
            WHERE local = :local 
            AND ativo = 1 
            AND situacao NOT IN ('escondido', 'fugindo', 'reagrupando soldados')
            ORDER BY personagem";
    
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':local', $localAtual, PDO::PARAM_STR);
    $stmt->execute();
    
    if ($stmt->rowCount() > 0) {
        echo "<h3 class='title'>Personagens em " . htmlspecialchars($localAtual) . "</h3>";
        echo "<div class='scroll-container'>";
        echo "<table class='personagens-table'>";
        echo "<thead>
                <tr>
                    <th>Personagem</th>
                    <th>Jogador</th>
                    <th>Situação</th>
                    <th>Reputação</th>
                    <th>Clã</th>
                    <th>Cargo</th>
                </tr>
              </thead>
              <tbody>";
        
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $situacao = htmlspecialchars($row['situacao']);
            
            if (in_array($row['situacao'], ['caçando', 'pegando madeira'])) {
                $paralisado = new DateTime($row['paralisado']);
                $agora = new DateTime();
                $status_class = ($paralisado <= $agora) ? 'status-completed' : 'status-inprogress';
                $status_text = ($paralisado <= $agora) ? '(concluído)' : '(em andamento)';
                $situacao .= " <span class='$status_class'>$status_text</span>";
            }
            
            echo "<tr>
                    <td>{$row['personagem']}</td>
                    <td>{$row['jogador']}</td>
                    <td>$situacao</td>
                    <td>{$row['reputacao']}</td>
                    <td>{$row['cla']}</td>
                    <td>{$row['cargo']}</td>
                </tr>";
        }
        
        echo "</tbody></table></div>";
        echo "<div class='total-personagens'>Total: " . $stmt->rowCount() . " personagens</div>";
    } else {
        echo "<div style='color: white; text-align: center; padding: 20px;'>Nenhum personagem ativo encontrado neste local.</div>";
    }
} catch (PDOException $e) {
    echo "<div style='color: white; text-align: center; padding: 20px;'>Erro ao consultar o banco de dados.</div>";
}

if (isset($_SESSION['personagem'])) {
    echo "<div style='color: #0066cc; text-align: center; margin: 15px 0; font-weight: bold;'>
            Seu personagem: " . htmlspecialchars($_SESSION['personagem']) . "
          </div>";
}
?>